/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.boss;

import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.network.IPacket;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.network.NetworkHooks;
import twilightforest.TwilightForestMod;
import twilightforest.entity.boss.HydraEntity;
import twilightforest.entity.boss.HydraHeadEntity;
import twilightforest.entity.boss.HydraPartEntity;

public class HydraMortarHead
extends ThrowableEntity {
    private static final int BURN_FACTOR = 5;
    private static final int DIRECT_DAMAGE = 18;
    public int fuse = 80;
    private boolean megaBlast = false;

    public HydraMortarHead(EntityType<? extends HydraMortarHead> type, World world) {
        super(type, world);
    }

    public HydraMortarHead(EntityType<? extends HydraMortarHead> type, World world, HydraHeadEntity head) {
        super(type, (LivingEntity)head.getParent(), world);
        Vector3d vector = head.func_70040_Z();
        double dist = 3.5;
        double px = head.func_226277_ct_() + vector.field_72450_a * dist;
        double py = head.func_226278_cu_() + 1.0 + vector.field_72448_b * dist;
        double pz = head.func_226281_cx_() + vector.field_72449_c * dist;
        this.func_70012_b(px, py, pz, 0.0f, 0.0f);
        head.func_213317_d(new Vector3d(0.0, 0.0, 0.0));
        this.func_234612_a_((Entity)head, head.field_70125_A, head.field_70177_z, -20.0f, 0.5f, 1.0f);
        TwilightForestMod.LOGGER.debug("Launching mortar! Current head motion is {}, {}", (Object)head.func_213322_ci().func_82615_a(), (Object)head.func_213322_ci().func_82616_c());
    }

    protected void func_70088_a() {
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_233570_aj_()) {
            this.func_213322_ci().func_216372_d(0.9, 0.9, 0.9);
            if (!this.field_70170_p.field_72995_K && this.fuse-- <= 0) {
                this.detonate();
            }
        }
    }

    public void setToBlasting() {
        this.megaBlast = true;
    }

    protected void func_70227_a(RayTraceResult ray) {
        if (ray instanceof EntityRayTraceResult) {
            if (!(this.field_70170_p.field_72995_K || ((EntityRayTraceResult)ray).func_216348_a() instanceof HydraMortarHead && ((HydraMortarHead)((EntityRayTraceResult)ray).func_216348_a()).func_234616_v_() == this.func_234616_v_() || ((EntityRayTraceResult)ray).func_216348_a() == this.func_234616_v_() || this.isPartOfHydra(((EntityRayTraceResult)ray).func_216348_a()))) {
                this.detonate();
            }
        } else if (!this.megaBlast) {
            this.func_213293_j(this.func_213322_ci().func_82615_a(), 0.0, this.func_213322_ci().func_82616_c());
            this.field_70122_E = true;
        } else {
            this.detonate();
        }
    }

    private boolean isPartOfHydra(Entity entity) {
        return this.func_234616_v_() instanceof HydraEntity && entity instanceof HydraPartEntity && ((HydraPartEntity)entity).getParent() == this.func_234616_v_();
    }

    public float func_180428_a(Explosion explosion, IBlockReader world, BlockPos pos, BlockState state, FluidState fluid, float p_180428_6_) {
        float resistance = super.func_180428_a(explosion, world, pos, state, fluid, p_180428_6_);
        if (this.megaBlast && state.func_177230_c() != Blocks.field_150357_h && state.func_177230_c() != Blocks.field_150384_bq && state.func_177230_c() != Blocks.field_150378_br) {
            resistance = Math.min(0.8f, resistance);
        }
        return resistance;
    }

    private void detonate() {
        float explosionPower = this.megaBlast ? 4.0f : 0.1f;
        boolean flag = ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this);
        Explosion.Mode flag1 = flag ? Explosion.Mode.BREAK : Explosion.Mode.NONE;
        this.field_70170_p.func_217398_a((Entity)this, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), explosionPower, flag, flag1);
        DamageSource src = new IndirectEntityDamageSource("onFire", (Entity)this, this.func_234616_v_()).func_76361_j().func_76349_b();
        for (Entity nearby : this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(1.0, 1.0, 1.0))) {
            if (!nearby.func_70097_a(src, 18.0f) || nearby.func_230279_az_()) continue;
            nearby.func_70015_d(5);
        }
        this.func_70106_y();
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        super.func_70097_a(source, amount);
        if (source.func_76346_g() != null && !this.field_70170_p.field_72995_K) {
            Vector3d vec3d = source.func_76346_g().func_70040_Z();
            if (vec3d != null) {
                this.func_70186_c(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 1.5f, 0.1f);
                this.field_70122_E = false;
                this.fuse += 20;
            }
            if (source.func_76346_g() instanceof LivingEntity) {
                this.func_212361_a(source.func_76346_g());
            }
            return true;
        }
        return false;
    }

    public boolean func_70027_ad() {
        return true;
    }

    public boolean func_70067_L() {
        return true;
    }

    public float func_70111_Y() {
        return 1.5f;
    }

    protected float func_70185_h() {
        return 0.05f;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

